local t = Def.ActorFrame {};
local colorToUse = cGreen;
local Time = THEME:GetMetric(Var "LoadingScreen","ShowOptionsMessageSeconds")

local function DifficultyMeter(pn)
	local diff = LoadFont("Common normal")..{
		Name="Difficulty"..pn;
		InitCommand=cmd(shadowlength,1);
		OnCommand=cmd(playcommand,"Set");

		SetCommand=function(self)
			-- player check
			if not GAMESTATE:IsHumanPlayer(pn) then
				self:visible(false);
				return;
			end;

			-- song/course check
			local SongOrCourse = nil;
			local StepsOrTrail = nil;
			if GAMESTATE:IsCourseMode() then
				SongOrCourse = GAMESTATE:GetCurrentCourse();
				StepsOrTrail = GAMESTATE:GetCurrentTrail(pn);
			else
				SongOrCourse = GAMESTATE:GetCurrentSong();
				StepsOrTrail = GAMESTATE:GetCurrentSteps(pn);
			end;

			if SongOrCourse == nil or StepsOrTrail == nil then
				self:visible(false);
				return;
			end;

			if SongOrCourse then
				if StepsOrTrail then
					local difficulty = StepsOrTrail:GetDifficulty();
					local meter = StepsOrTrail:GetMeter();

					self:diffuse( DifficultyColor(StepsOrTrail:GetDifficulty()) );
					self:NoStroke();
					self:shadowcolor( DarkColor(DifficultyColor(StepsOrTrail:GetDifficulty())) );

					if difficulty == 'Difficulty_Edit' then
						diffstring = StepsOrTrail:GetDescription();
						if diffstring == "" then
							diffstring = "(untitled)";
						end;
						self:zoom(0.75);
					else
						diffstring = "";
						self:zoom(1);
					end;

					self:settext(diffstring .." ".. meter);
				else
					self:settext("");
				end;
			else
				self:settext("");
			end;

			-- if we make it down here, we can be visible
			self:visible(true);
		end;
		OffCommand=cmd(linear,0.2;diffusealpha,0);
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");

		CurrentStepsP1ChangedMessageCommand=function(self)
			if pn == PLAYER_1 then self:playcommand("Set"); end;
		end;
		CurrentTrailP1ChangedMessageCommand=function(self)
			if pn == PLAYER_1 then self:playcommand("Set"); end;
		end;
		CurrentStepsP2ChangedMessageCommand=function(self)
			if pn == PLAYER_2 then self:playcommand("Set"); end;
		end;
		CurrentTrailP2ChangedMessageCommand=function(self)
			if pn == PLAYER_2 then self:playcommand("Set"); end;
		end;
	};
	return diff;

--[[
	local function set(self, player)
		self:SetFromGameState( player );
	end

	local t = Def.DifficultyMeter {
		Type="DifficultyMeter"; -- metrics section
	};

	if pn == PLAYER_1 then
		t.CurrentStepsP1ChangedMessageCommand=function(self) set(self, pn); end;
		t.CurrentTrailP1ChangedMessageCommand=function(self) set(self, pn); end;
	else
		t.CurrentStepsP2ChangedMessageCommand=function(self) set(self, pn); end;
		t.CurrentTrailP2ChangedMessageCommand=function(self) set(self, pn); end;
	end

	return t;
]]
end

local function Profile(pn)
	if PROFILEMAN:IsPersistentProfile(pn) then
		-- player profile
		return PROFILEMAN:GetProfile(pn);
	else
		-- machine profile
		return PROFILEMAN:GetMachineProfile();
	end;
end;
-- Score Func ( Thanks AJ );
local function PlayerScore(pn)
	local s = LoadFont("Common Normal")..{
		Name="Score"..pn;
		InitCommand=cmd(NoStroke;shadowlength,1;diffuse,PlayerColor(pn);player,pn);
		OnCommand=cmd(playcommand,"Set");
		
		SetCommand=function(self)
			-- Grab the song and course. We don't know if this is going to
			-- be called on SSMusic or SSCourse, so it's good to get both.
			-- We'll filter this later.
			local song = GAMESTATE:GetCurrentSong();
			local course = GAMESTATE:GetCurrentCourse();
			
			-- set up some variables that are used in both functions.
			local scorelist;
			local text = "";
			local profile;
			if song then
				-- we have a song, we need some steps
				local steps = GAMESTATE:GetCurrentSteps(pn);
				
				if steps then
					-- get profile
					profile = Profile(pn);
					-- populate high score list
					scorelist = profile:GetHighScoreList(song,steps);
					-- a little bird told me this trick:
					assert(scorelist);
					-- get all the scores from the score list
					local scores = scorelist:GetHighScores();
					
					-- get the top score
					local topscore = scores[1];
					-- if it doesn't exist, set it to 0. this took me forever
					-- to find a workaround since if there are no high scores
					-- for a song this will BREAK.
					if not topscore then
						text = string.format("%.2f%%", 0);
					else
						-- There IS a high score, format it to percentages
						-- and be on our merry way.
						text = string.format("%.2f%%", topscore:GetPercentDP()*100.0);
					end;
				else
					-- no steps. do nothing.
					return;
				end;
			-- the course code is pretty much the same, aside from the args to
			-- Profile:GetHighScoreList.
			elseif course then
				-- we have a course, get a trail
				local trail = GAMESTATE:GetCurrentTrail(pn);
				if trail then
					-- get profile
					profile = Profile(pn);
					-- populate high score list
					scorelist = profile:GetHighScoreList(course,trail);
					assert(scorelist);
					
					local scores = scorelist:GetHighScores();
					-- get the top score
					local topscore = scores[1];
					if not topscore then
						text = string.format("%.2f%%", 0);
					else
						text = string.format("%.2f%%", topscore:GetPercentDP()*100.0);
					end;
				else
					-- no trail. do nothing.
					return;
				end;
			else
				text = string.format("%.2f%%", 0); -- BUST BACK
			end;
			self:settext(text);
		end;
		-- song and course changes
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
		-- steps and trail changes
		CurrentStepsP1ChangedMessageCommand=function(self)
			if pn == PLAYER_1 then self:playcommand("Set"); end;
		end;
		CurrentStepsP2ChangedMessageCommand=function(self)
			if pn == PLAYER_2 then self:playcommand("Set"); end;
		end;
		
		CurrentTrailP1ChangedMessageCommand=function(self)
			if pn == PLAYER_1 then self:playcommand("Set"); end;
		end;
		CurrentTrailP2ChangedMessageCommand=function(self)
			if pn == PLAYER_2 then self:playcommand("Set"); end;
		end;
	};
	
	return s;
end;

-- MenuElements
t[#t+1]	= LoadActor(THEME:GetPathB("ScreenWithMenuElements","overlay"));
-- Banner
t[#t+1] = Def.ActorFrame {
 InitCommand=cmd(x,SCREEN_CENTER_X-160;y,SCREEN_TOP+100);
	Def.Quad {
		InitCommand=cmd(zoomto,256,80);
	};
	Def.ActorProxy {
		BeginCommand=function(self) local banner = SCREENMAN:GetTopScreen():GetChild('Banner'); self:SetTarget(banner); end;
	};
	LoadActor( "_banner frame" );
};
-- Barplace ( Sort ) 
t[#t+1] = Def.ActorFrame {
 InitCommand=cmd(visible,false);
	LoadActor(THEME:GetPathG("MusicWheelItem SectionCollapsed", "NormalPart")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X);
	};
};
-- Song Info
t[#t+1] = Def.ActorFrame {
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-160+70;y,SCREEN_TOP+100+64);
		OnCommand=cmd(diffuse,DarkColor(cBlue);fadeleft,1;zoomtowidth,140);
	};
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-160-70;y,SCREEN_TOP+100+64;zoomx,-1);
		OnCommand=cmd(diffuse,DarkColor(cBlue);faderight,1;zoomtowidth,140);
	};
	-- BPM
	LoadFont("Common Normal") .. {
		Text="BPM:";
		InitCommand=cmd(NoStroke;horizalign,left;x,SCREEN_CENTER_X-160-96-32+4;y,SCREEN_TOP+100+64-10;zoom,0.5;shadowlength,1;);
	};
	Def.BPMDisplay {
		File=THEME:GetPathF("Common","Normal");
		Name="BPMDisplay";
		InitCommand=cmd(horizalign,left;x,SCREEN_CENTER_X-160-96+24;y,SCREEN_TOP+100+64-10;zoom,0.8;shadowlength,1;);
		SetCommand=function(self) self:SetFromGameState() end;
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
	};
	-- Genre
	LoadFont("Common Normal") .. {
		Text="GENRE";
		InitCommand=cmd(x,SCREEN_CENTER_X-160-40;y,SCREEN_TOP+100+64+10;zoom,0.5;NoStroke;shadowlength,1;);
		CurrentSongChangedMessageCommand=function(self)
			local song = GAMESTATE:GetCurrentSong();
			local genre = GenreGen.Generate();
			self:stoptweening();
			if song then
				if song:GetGenre() ~= "" then
					genre = song:GetGenre();
					self:skewx(0);
					self:diffusealpha(1);
				else
					self:skewx(-0.1);
					self:diffusealpha(0.95);
				end
				self:maxwidth(240);
			else
				genre = "";
			end
			self:settext( genre );
		end;
	};
	-- Time
--[[ 	LoadFont("Common Normal") .. {
		Text="Time:";
		InitCommand=cmd(horizalign,left;x,SCREEN_CENTER_X-160-96-32+4;y,SCREEN_TOP+100+64+10;zoom,0.5;NoStroke;shadowlength,1;);
	};
	LoadFont("Common Normal") .. {
		SetCommand=function(self)
			local song = GAMESTATE:GetCurrentSong()
			local course = GAMESTATE:GetCurrentCourse()
			if not song and not course then
				self:hidden(1)
				return
			end
			self:hidden(0)
			local time
			if song then time = song:MusicLengthSeconds() end
			if course then
				local st = GAMESTATE:GetCurrentStyle():GetStepsType()
				time = course:GetTotalSeconds( st )
			end
			if time then
                if time == 105 then
                    self:settext( "r21 Patched" );
                    self:rainbowscroll(true);
                end
                if time ~= 105 then
				    self:settext( SecondsToMSSMsMs(time) );
                    self:rainbowscroll(false);
                end
--~                 self:settext( time );
			else
				self:settext( "xx:xx.xx" );
			end
		end;

		InitCommand=cmd(horizalign,left;x,SCREEN_CENTER_X-160-96+24;y,SCREEN_TOP+100+64+10;zoom,0.5;NoStroke;shadowlength,1;);

		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
	}; --]]
};

-- Difficulty List / Course List
t[#t+1] = Def.ActorFrame {
--~  InitCommand=cmd(visible,false);
	LoadActor("panedisplay") .. {
		Condition=(GAMESTATE:IsCourseMode() == false);
		InitCommand=cmd(x,SCREEN_CENTER_X-160-80;y,SCREEN_TOP+100+64+40);
		OnCommand=cmd(visible,GAMESTATE:IsCourseMode() == false);
	};
	Def.CourseContentsList {
		MaxSongs = 5;

		InitCommand=cmd(x,SCREEN_CENTER_X-160;y,SCREEN_TOP+100+64+40);
		ShowCommand=cmd(bouncebegin,0.3;zoomy,1);
		HideCommand=cmd(linear,0.3;zoomy,0);
		SetCommand=function(self)
			self:SetFromGameState();
--             self:setsecondsperitem(0.25);
-- 			self:SetSecondsPauseBetweenItems(0.5);
-- 			self:scrollwithpadding(0, 0);
		end;
		CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
		CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");

		Display = Def.ActorFrame { 
			InitCommand=cmd(setsize,200,30);

            LoadActor( THEME:GetPathB("","_frame 3x1"), "Pill Difficulty", 190)..{
                SetSongCommand=function(self,params)
                    self:diffuse( DarkColor( DifficultyColor(params.Difficulty) ) );
                end;
            };

            LoadFont("Common Normal") .. {
				OnCommand=cmd(y,-1;x,-108+10;horizalign,left;NoStroke;shadowlength,1;zoom,0.5;maxwidth,280);
				SetSongCommand=function(self, params) 
                    self:settext(params.Song:GetDisplayMainTitle());
                    self:diffuse( LightColor( DifficultyColor(params.Difficulty) ) )
                    self:diffusebottomedge( DifficultyColor(params.Difficulty) )
                end
			};
			LoadFont("Common Normal") .. {
				OnCommand=cmd(x,-108;zoom,0.5;y,-1;NoStroke;shadowlength,1;);
				SetSongCommand=function(self, params) 
                    self:settext(string.format("%i", params.Number));
                end
			};

 			LoadFont("Common Normal") .. {
				OnCommand=cmd(x,108;y,-1;zoom,0.75;NoStroke;shadowlength,1;);
				SetSongCommand=function(self, params)
					if params.PlayerNumber ~= GAMESTATE:GetMasterPlayerNumber() then return end
					self:settext( params.Meter );
                    self:diffuse( LightColor(DifficultyColor(params.Difficulty)) )
					self:diffusebottomedge( DifficultyColor(params.Difficulty) );
					
 					if params.Meter >= 10 then
						self:glowshift();
					else
						self:stopeffect();
					end
				end;
			};
			--[[
			DifficultyMeter(PLAYER_1) .. {
				OnCommand=cmd(x,108-36;zoom,0.75;shadowlength,0);
			};
			]]
		};
	};
};
-- Player Scores
t[#t+1] = Def.ActorFrame {
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,THEME:GetMetric("ScreenWithMenuElements","StatusP1X");y,THEME:GetMetric("ScreenWithMenuElements","StatusP1Y")-28;player,PLAYER_1);
		OnCommand=cmd(skewx,-0.25;diffuse,PlayerColor(PLAYER_1);fadeleft,1;zoomtowidth,210);
	};
	LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
		InitCommand=cmd(x,THEME:GetMetric("ScreenWithMenuElements","StatusP2X");y,THEME:GetMetric("ScreenWithMenuElements","StatusP2Y")-28;player,PLAYER_2);
		OnCommand=cmd(skewx,0.25;diffuse,PlayerColor(PLAYER_2);faderight,1;zoomtowidth,210);
	};
	
	PlayerScore(PLAYER_1) .. {
		InitCommand=cmd(x,THEME:GetMetric("ScreenWithMenuElements","StatusP1X")-22;y,THEME:GetMetric("ScreenWithMenuElements","StatusP1Y")-34);
	};
	DifficultyMeter(PLAYER_1) .. {
		InitCommand=cmd(player,PLAYER_1;x,THEME:GetMetric("ScreenWithMenuElements","StatusP1X")+64;y,THEME:GetMetric("ScreenWithMenuElements","StatusP1Y")-28);
	};
	LoadFont("Common Normal") .. {
		Text="P1 Best";
		InitCommand=cmd(player,PLAYER_1;NoStroke;shadowlength,1;zoom,0.5;x,THEME:GetMetric("ScreenWithMenuElements","StatusP1X")-22;y,THEME:GetMetric("ScreenWithMenuElements","StatusP1Y")-16);
		OnCommand=function(self)
			if GAMESTATE:IsPlayerEnabled(PLAYER_1) == true then
				self:settext(GAMESTATE:GetPlayerDisplayName(PLAYER_1) .. "'s Best");
			end
		end
	};
	PlayerScore(PLAYER_2) .. {
		InitCommand=cmd(x,THEME:GetMetric("ScreenWithMenuElements","StatusP2X")+22;y,THEME:GetMetric("ScreenWithMenuElements","StatusP2Y")-34);
	};
	DifficultyMeter(PLAYER_2) .. {
		InitCommand=cmd(player,PLAYER_2;x,THEME:GetMetric("ScreenWithMenuElements","StatusP2X")-64;y,THEME:GetMetric("ScreenWithMenuElements","StatusP2Y")-28);
	};
	LoadFont("Common Normal") .. {
		Text="P2 Best";
		InitCommand=cmd(player,PLAYER_2;NoStroke;shadowlength,1;zoom,0.5;x,THEME:GetMetric("ScreenWithMenuElements","StatusP2X")+22;y,THEME:GetMetric("ScreenWithMenuElements","StatusP2Y")-16);
		OnCommand=function(self)
			if GAMESTATE:IsPlayerEnabled(PLAYER_2) == true then
				self:settext(GAMESTATE:GetPlayerDisplayName(PLAYER_2)  .. "'s Best");
			end
		end
	};
};
-- Final Difficulties & Time
t[#t+1] = Def.ActorFrame {
--  InitCommand=cmd(visible,false);
	LoadActor("difficulties") .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-160-80+16;y,SCREEN_TOP+100+64+40+120);
	};
	--LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
	LoadActor(THEME:GetPathB("","frame")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-160;y,SCREEN_TOP+100+64+40+120+40);
		--OnCommand=cmd(diffuse,DarkColor(cBlue);faderight,1;zoomtowidth,210);
		OnCommand=cmd(diffuse,cBlue;faderight,1;zoomtowidth,210);
	};
	--LoadActor(THEME:GetPathG("Player","Combo/_background")) .. {
	LoadActor(THEME:GetPathB("","frame")) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-160;y,SCREEN_TOP+100+64+40+120+40);
		--OnCommand=cmd(diffuse,DarkColor(cBlue);fadeleft,1;zoomtowidth,210);
		OnCommand=cmd(diffuse,DarkColor(cBlue);fadeleft,1;zoomtowidth,210);
	};
	LoadFont("Combo", "Numbers") .. {
		SetCommand=function(self)
			local song = GAMESTATE:GetCurrentSong()
			local course = GAMESTATE:GetCurrentCourse()
			if not song and not course then
				self:hidden(1)
				return
			end
			self:hidden(0)
			local time
			if song then time = song:MusicLengthSeconds() end
			if course then
				local st = GAMESTATE:GetCurrentStyle():GetStepsType()
				time = course:GetTotalSeconds( st )
			end
			if time then
				self:settext( SecondsToMSSMsMs(time) );
			else
				self:settext( "xx:xx.xx" );
			end
		end;

		InitCommand=cmd(x,SCREEN_CENTER_X-160;y,SCREEN_TOP+100+64+40+120+40-12;NoStroke;shadowlength,1;zoom,0.75);
		OnCommand=cmd(diffusealpha,0;linear,0.5;diffusealpha,1);
		OffCommand=cmd(linear,0.5;diffusealpha,0);

		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
	};
	LoadFont("Common Normal") .. {
		Text="SONG LENGTH";
		InitCommand=cmd(x,SCREEN_CENTER_X-160;y,SCREEN_TOP+100+64+40+120+40+12;NoStroke;shadowlength,1;zoom,0.5);
		OnCommand=cmd(diffusealpha,0;linear,0.5;diffusealpha,1);
		OffCommand=cmd(linear,0.5;diffusealpha,0);
	};
};
-- Options Out Original
t[#t+1] = Def.ActorFrame {
 InitCommand=cmd(visible,false);
	Def.Quad {
		InitCommand=cmd(visible,false;FullScreen;diffuse,0,0,0,1);
		ShowPressStartForOptionsCommand=cmd(visible,true;);
	};
	-- Prog Meter
	Def.ActorFrame {
	 InitCommand=cmd(x,SCREEN_RIGHT;y,SCREEN_CENTER_Y;spin);
		LoadActor(THEME:GetPathB("_shared","background original/ring")) .. {
			InitCommand=cmd(visible,false;zoom,0.8);
			ShowPressStartForOptionsCommand=cmd(visible,true;linear,Time;zoom,0.5;diffuse,cBlue);
			ShowEnteringOptionsCommand=cmd(stoptweening;bouncebegin,0.15;diffuse,cGreen;zoom,0.65;linear,0.15;diffusealpha,0);
			HidePressStartForOptionsCommand=cmd(stoptweening;bouncebegin,0.15;diffuse,cRed;zoom,0.65;linear,0.15;diffusealpha,0);
		};
	};

	Def.Quad {
		InitCommand=cmd(visible,false;Center;y,SCREEN_CENTER_Y+40;zoomto,232+4,20+4;diffuse,cRed);
		ShowPressStartForOptionsCommand=cmd(visible,true;cropright,0;linear,Time;cropright,0;diffuse,DarkColor(cBlue);diffuserightedge,cBlue);
		ShowEnteringOptionsCommand=cmd(stoptweening;linear,0.3;cropright,0;diffuse,DarkColor(cGreen);diffuserightedge,cGreen;sleep,0.2;bounceend,0.2;zoomy,0);
		HidePressStartForOptionsCommand=cmd(stoptweening;linear,0.3;diffuse,DarkColor(cRed);diffusebottomedge,cRed;sleep,0.2;bounceend,0.2;zoomy,0);
	};
	
	Def.Quad {
		InitCommand=cmd(visible,false;Center;y,SCREEN_CENTER_Y+40;zoomto,232,20;diffuse,cRed);
		ShowPressStartForOptionsCommand=cmd(visible,true;cropright,1;linear,Time;cropright,0;diffuse,cBlue;diffuserightedge,LightColor(cBlue));
		ShowEnteringOptionsCommand=cmd(stoptweening;linear,0.3;cropright,0;diffuse,cGreen;diffuserightedge,LightColor(cGreen);sleep,0.2;bounceend,0.2;zoomy,0);
		HidePressStartForOptionsCommand=cmd(stoptweening;linear,0.3;diffuse,cRed;diffusebottomedge,DarkColor(cRed);sleep,0.2;bounceend,0.2;zoomy,0);
	};
	LoadFont("Common","Normal") .. {
		InitCommand=cmd(Center;NoStroke;visible,false;rotationz,360;diffusealpha,0);
		ShowPressStartForOptionsCommand=cmd(settext,"PRESS &START; FOR OPTIONS";visible,true;decelerate,Time/4;rotationz,0;diffusealpha,1;
			linear,(Time/4)*3;zoom,0.7;diffusealpha,0);
		ShowEnteringOptionsCommand=cmd(settext,"ENTERING OPTIONS";stoptweening;bounceend,0.3;rotationz,0;zoom,0.7;diffuse,cGreen;accelerate,0.25;zoom,1.3;diffusealpha,0);
		HidePressStartForOptionsCommand=cmd(settext,"GET READY!";stoptweening;decelerate,0.3;rotationz,0;zoom,0.7;diffuse,cRed;accelerate,1;zoom,1.3;diffusealpha,0);
	};
	Def.Quad {
		InitCommand=cmd(visible,false;FullScreen);
		ShowPressStartForOptionsCommand=cmd(visible,true;linear,Time/6;diffusealpha,0);
	};
};
-- Options Out New
t[#t+1] = Def.ActorFrame {
	Def.ActorFrame {
	 InitCommand=cmd(Center;visible,false);
	 ShowPressStartForOptionsCommand=cmd(visible,true);
		-- BG Killer
		Def.Quad {
			InitCommand=cmd(vertalign,bottom;y,(-110/2)+8;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;);
			ShowPressStartForOptionsCommand=cmd(diffuse,DarkColor(colorToUse);diffusealpha,0.5;addy,-32;decelerate,0.5;addy,32;diffusealpha,1;diffusetopedge,DarkColor(DarkColor(colorToUse)));
			ShowEnteringOptionsCommand=cmd(diffuse,cBlue);
		};
		Def.Quad {
			InitCommand=cmd(vertalign,top;y,(110/2)+8;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT);
			ShowPressStartForOptionsCommand=cmd(diffuse,DarkColor(colorToUse);diffusealpha,0.5;addy,32;decelerate,0.5;addy,-32;diffusealpha,1;diffusebottomedge,DarkColor(DarkColor(colorToUse)));
			ShowEnteringOptionsCommand=cmd(diffuse,cBlue);
		};
		-- Inside BG Killer
		Def.Quad {
			InitCommand=cmd(zoomto,SCREEN_WIDTH,(220/2);y,8);
			ShowPressStartForOptionsCommand=cmd(diffuse,colorToUse;zoomtoheight,(220/2)+(196/4);diffusealpha,0;linear,0.5;diffusealpha,1;zoomtoheight,(220/2);;linear,0.2;diffuse,0,0,0,1);
			ShowEnteringOptionsCommand=cmd(diffuse,DarkColor(cBlue));
		};
		-- Swipes
		LoadActor( THEME:GetPathG("_logo", "normal/under") ) .. {
			InitCommand=cmd(diffuse,colorToUse;zoomtowidth,SCREEN_WIDTH);
			ShowPressStartForOptionsCommand=cmd(zoomtoheight,220+196;diffuse,1,1,1,1;decelerate,0.5;zoomtoheight,220;diffuse,colorToUse);
			ShowEnteringOptionsCommand=cmd(diffuse,cBlue);
		};
		LoadActor( THEME:GetPathG("_dynamic","footer/seperator") ) .. {
			InitCommand=cmd(zoomtowidth,SCREEN_WIDTH;y,(-110/2)+8);
			ShowPressStartForOptionsCommand=cmd(addy,-32;decelerate,0.5;addy,32);
		};
		LoadActor( THEME:GetPathG("_dynamic","footer/seperator") ) .. {
			InitCommand=cmd(zoomtowidth,SCREEN_WIDTH;y,(110/2)+8);
			ShowPressStartForOptionsCommand=cmd(addy,32;decelerate,0.5;addy,-32);
		};
		-- Text
		LoadFont("_regra black 50px") .. {
			Text="SONG SELECTION";
			InitCommand=cmd(NoStroke;shadowlength,1;diffusebottomedge,0.8,0.8,0.8,1);
			ShowPressStartForOptionsCommand=cmd(diffusealpha,0;zoom,1;zoomx,1.2;spring,0.5;diffusealpha,1;zoom,0.75);
			ShowEnteringOptionsCommand=cmd(diffusebottomedge,cBlue);
		};
		LoadFont("Common Normal") .. {
			Text="Press &START; For Options";
			InitCommand=cmd(y,25;NoStroke;shadowlength,1;diffusebottomedge,0.8,0.8,0.8,1);
			ShowPressStartForOptionsCommand=cmd(diffusealpha,0;zoom,1;zoomx,1.2;spring,0.5;diffusealpha,1;zoom,0.75);
			ShowEnteringOptionsCommand=cmd(settext,"Entering Options";diffusebottomedge,cBlue);
		};
		Def.Quad {
			InitCommand=cmd(diffuse,LightColor(cBlue);zoomto,SCREEN_WIDTH,SCREEN_HEIGHT);
			ShowPressStartForOptionsCommand=cmd(diffusealpha,0);
			ShowEnteringOptionsCommand=cmd(diffusealpha,1;linear,0.1;diffusealpha,0;sleep,0.5;linear,0.2;diffuse,1,1,1,1);
			HidePressStartForOptionsCommand=cmd(linear,0.3;diffuse,0,0,0,1);
		};
	};
};
return t;
